# Endocranial4.R
# Multiple regression for endocranial volume in mammals

# Load necessary libraries
library(ggplot2)
library(car)
library(QuantPsyc)

# Read in data set
ECVdat <- read.table(header=T,colClasses=c(rep("numeric",4),"factor"),text="
Length  Width   Height  Volume  Common_name
15.04   11.29   6.61    0.38    Pygmy_glider
52.40   30.94   25.68   12.36   Rufous_kangaroo_rat
75.87   52.79   39.45   56.70   Howler_monkey
41.73   25.70   16.79   5.68    Scaley-tailed_squirrel
39.71   26.87   17.13   5.92    Lord_derby's_flying_squirrel
18.90   12.62   7.61    0.51    Yellow-footed_antechinus
15.10   11.69   7.06    0.46    Brown_antechinus
123.70  73.89   63.93   150.53  Pronghorn
46.75   28.70   18.45   6.51    Mountain_beaver
154.32  103.77  71.95   284.03  Antarctic_fur_seal
133.39  59.75   72.60   128.49  Babiroussa
49.43   29.61   24.27   9.49    Burrowing_bettong
61.51   32.76   27.05   16.43   Pale_throated_sloth
36.65   23.94   19.64   6.22    Common_marmoset
37.96   22.94   16.72   4.71    Plantain_squirrel
30.10   18.69   12.75   2.20    Bare_tailed_wooly_opossum
227.53  96.85   100.03  547.78  Dromedary_camel
87.04   52.86   45.46   66.40   Golden_jackal
98.73   59.43   53.36   91.65   Coyote
121.53  73.22   61.13   135.40  Wolf
120.81  68.38   62.67   151.03  Wild_goat
102.14  59.34   50.41   94.82   Roe_deer
51.14   21.72   18.46   6.31    Hutia
83.34   40.79   33.60   37.88   American_beaver
42.17   23.14   16.20   3.93    Guinea_pig
73.58   52.90   42.11   67.96   Capuchin
98.54   59.24   49.03   82.44   Common_duiker
74.43   57.25   44.83   72.19   Guenon
70.37   54.11   44.03   65.96   Mona_monkey
39.62   23.90   17.39   4.39    Chinchilla
26.37   22.97   13.25   2.30    Pink_fairy_armadillo
93.63   49.10   43.75   35.10   Two_toed_tree_sloth
93.24   41.11   36.58   36.65   African_civet_cat
30.63   17.31   13.42   1.67    European_hamster
126.62  117.09  81.10   376.40  Hooded_seal
11.69   9.82    5.47    0.22    Olivers_shrew
159.07  82.94   80.42   164.22  Spotted_hyaena
28.23   17.47   13.22   2.37    Tuco-tuco
97.54   50.66   34.43   32.76   Paca
41.47   21.95   16.57   3.87    Prarie_dog
134.68  77.44   76.70   232.99  Fallow_deer
67.83   33.66   28.93   19.25   Golden_acouti
50.01   24.99   20.18   5.01    Southern_long_nosed_armadillo
62.29   30.57   25.52   11.45   Armadillo
43.00   23.88   16.47   4.28    Chuditch
53.27   27.81   21.63   8.45    Tiger_quoll
37.73   23.57   16.46   4.97    Quoll
70.40   44.74   38.94   40.26   Aye-aye
80.18   34.10   33.94   22.45   Tree_hyrax
18.20   12.87   10.06   0.87    Vampire_bat
51.10   25.83   20.13   6.02    American_opossum
22.16   16.88   12.42   1.53    Ord's_kangaroo_rat
159.31  116.10  111.67  418.77  Dugong
36.02   20.18   14.76   3.47    Equatorial_fruit_bat
109.38  79.78   48.74   127.26  Sea_otter
282.83  95.88   99.82   503.33  Horse
59.41   35.67   28.44   20.54   New_world_porcupine
36.22   23.15   15.16   3.27    Hedgehog
35.65   23.67   17.13   4.99    Galago
128.38  72.40   57.86   133.05  Puma
173.29  100.56  80.01   225.29  Lion
100.81  59.32   48.56   83.41   Lynx
76.86   47.30   36.21   41.07   Wild_cat
35.01   23.69   17.80   4.55    Allens_bushbaby
26.63   18.83   14.09   3.01    Demidoffs_bushbaby
42.06   25.63   16.80   5.61    Philippine_flying_lemur
95.40   56.17   50.88   76.72   Dorcas_gazelle
160.80  101.21  93.39   482.16  Western_gorilla
23.92   16.09   10.91   1.61    Huets_dormouse
104.47  67.64   44.41   80.51   Wolverine
38.37   23.24   16.73   4.98    Red_legged_sun_squirrel
23.09   14.36   10.99   0.85    Streaked_tenrec
76.79   35.09   30.74   22.46   Mongoose
17.11   10.87   8.02    0.54    Cyclops_leaf_nosed_bat
133.08  56.98   63.04   84.91   Capybara
36.54   21.55   16.43   4.66    Water_rat
72.70   36.84   35.00   24.01   water_chevrotain
78.37   57.84   49.03   99.45   Gibbon
34.08   20.41   14.08   3.23    Hammer_headed_fruit_bat
67.60   59.95   37.45   38.39   African_crested_porcupine
47.54   29.29   22.87   9.85    Zorilla
20.73   11.28   8.56    0.67    Long_eared_flying_squirrel
16.06   10.13   7.31    0.42    Zenkers_flying_squirrel
41.76   24.66   19.16   4.28    Short_nosed_bandicoot
64.81   38.62   27.34   17.28   Viscacha
20.54   13.34   7.75    0.60    Norway_lemming
62.35   36.55   27.99   20.24   Lemur
65.09   32.79   27.01   14.60   Brown_hare
58.45   30.84   25.73   13.05   Arctic_hare
86.67   56.04   37.26   54.62   Common_otter
76.59   56.59   44.39   64.67   Long_tailed_macaque
85.38   62.54   52.20   93.73   Barbary_macacque
98.86   47.55   53.30   64.78   Grey_kangaroo
89.57   51.95   47.71   49.25   Red_kangaroo
22.05   15.08   10.14   1.09    Elephant_shrew
52.76   28.63   22.75   6.19    Bilby
62.37   40.11   36.06   24.43   Salts_dikdik
50.98   34.43   24.87   11.23   Malayan_pangolin
46.38   32.55   22.74   10.56   Tree_pangolin
26.08   16.11   10.78   1.34    German_oppossom
56.49   30.59   22.84   11.11   Alpine_marmott
58.54   34.60   26.06   17.45   Pine_marten
82.91   45.41   32.90   35.42   Fisher_martin
86.63   52.49   38.33   52.95   Badger
18.85   10.87   7.74    0.39    Common_vole
10.56   8.38    5.55    0.15    Pallas_mastiff_bat
14.78   9.96    7.77    0.40    Leach's_Single_Leaf_Bat
81.07   46.47   42.52   46.24   Muntjack
15.20   10.37   7.27    0.35    European_house_mouse
36.51   21.52   15.54   4.41    Stoat
30.75   17.43   12.79   2.44    Weasel
47.76   27.53   18.68   7.45    Polecat
61.61   32.43   24.39   14.21   Nutria
10.06   7.74    5.53    0.14    Natterers_bat
47.47   21.65   15.54   3.40    Numbat
214.43  60.30   44.93   90.29   Giant_anteater
85.17   61.89   48.42   96.62   Proboscis_monkey
75.02   43.24   34.97   31.31   Coati
11.56   10.00   6.27    0.24    African_noctule
44.81   29.68   23.35   9.01    Slow_loris
29.52   15.12   12.87   1.91    Degu
39.46   33.07   21.80   10.14   Platypus
116.81  60.29   41.61   93.11   Aardvark
62.59   28.45   25.55   10.86   Rabbit
230.21  111.32  106.00  618.82  South_american_sea_lion
92.60   51.50   45.50   61.07   Oribi
109.53  61.76   75.18   98.17   Sheep
126.37  95.65   83.38   369.27  Chimpanzee
103.97  76.88   62.57   164.20  Savanna_baboon
78.20   35.51   28.98   20.14   Asian_palm_civet
113.57  55.36   65.56   91.89   Collared_peccary
58.60   37.51   31.76   19.16   Cape_jumping_hare
40.97   22.52   18.15   3.79    Eastern_barred_bandicoot
47.39   31.40   22.98   11.60   Potto
36.12   20.03   14.74   3.68    Greater_glider
28.87   17.62   12.55   2.11    Sugar_glider
39.63   23.49   15.92   4.61    Gliding_phalanger
67.27   36.19   33.66   20.99   Yellow-footed_rock_wallaby
28.16   18.47   11.34   1.54    Tuan
86.46   37.53   30.73   20.14   Koala
123.14  95.18   68.06   270.19  Common_seal
12.94   8.52    5.34    0.15    Bat
131.37  103.46  95.66   456.72  Orangutan
30.19   19.17   13.35   2.90    Giant_otter_shrew
56.85   30.31   25.11   11.00   Rat_kangaroo
66.24   40.36   32.77   30.35   Kinkajou
77.20   53.23   45.77   68.40   Maroon_leaf_monkey
59.75   31.51   30.40   15.94   Rock_hyrax
73.12   47.11   34.06   38.66   Racoon
71.67   47.92   35.74   44.24   Diademed_sifaka
87.78   49.07   36.98   41.94   Aardwolf
40.35   23.85   18.20   4.52    Queensland_ringtail
39.68   21.96   18.00   4.42    Common_ringtail
48.16   24.27   18.45   6.48    Flying_fox
160.26  93.70   88.03   299.45  Reindeer
31.80   16.86   12.95   1.98    Common_rat
27.67   16.43   11.45   1.54    House_rat
50.41   29.20   20.53   9.56    Cream_coloured_giant_squirrel
54.96   30.62   19.80   10.91   Black_giant_squirrel
40.73   24.70   17.13   3.98    Checkered_elephant_shrew
64.74   41.76   29.09   12.09   Tasmanian_Devil
27.29   16.87   12.85   2.03    Kashmir_flying_squirrel
76.63   56.41   45.54   63.02   Leaf_monkey
16.20   10.27   6.50    0.30    Stripe-faced_dunnart
48.43   24.65   15.55   4.34    Solenadon
65.79   34.78   24.80   13.36   Spotted_cuscus
24.38   11.48   7.08    0.49    Musk_shrew
27.25   18.07   13.07   2.00    Slender_squirrel
47.52   31.29   23.02   10.59   Meerkat
207.58  82.99   90.04   227.39  Bearded_pig
125.76  68.74   75.39   142.29  Wild_boar
49.85   47.47   26.29   25.78   Short_nosed_echidna
22.66   16.17   12.85   1.46    East_african_mole_rat
22.30   15.69   9.20    0.86    European_mole
79.76   38.36   26.63   23.17   Southern_Tamandua
28.29   17.55   11.87   1.96    Eastern_chipmunk
206.48  98.53   122.39  369.78  Tapir
31.32   22.25   16.81   2.61    tarsier
129.48  66.22   76.62   167.16  White_lipped_peccary
43.80   21.11   15.93   2.27    Tail-less_tenrec
107.59  51.60   44.35   50.76   Tasmanian_wolf
66.24   31.63   31.22   14.29   Chevrotain
60.41   28.69   23.70   11.26   Bush_tailed_possum
31.16   18.44   13.79   2.11    Northern_tree_shrew
32.90   19.83   14.73   3.19    Tree_shrew
32.15   20.33   13.95   3.17    Painted_tree_shrew
200.23  98.99   84.53   358.82  Brown_bear
179.70  95.48   75.51   302.72  Sloth_bear
67.48   42.35   29.66   24.79   Ruffled_lemur
70.78   30.98   28.08   17.91   Rasse
67.05   54.15   44.99   56.71   Wombat
70.36   45.09   37.72   38.43   Arctic_fox
80.73   47.96   39.45   48.55   Fox
13.54   9.24    7.13    0.36    Meadow_jumping_mouse	
13.15   9.05    7.00     NA     Fossil_mouse
190.17  97.32   80.31    NA     Fossil_bear
")

# Apply transformations here
ECVdat <- transform(ECVdat,logV=log(Volume))
ECVdat <- transform(ECVdat,logL=log(Length))
ECVdat <- transform(ECVdat,logH=log(Height))
ECVdat <- transform(ECVdat,logW=log(Width))

# Print data
ECVdat

# Graphics using ggplot2
ggplot(ECVdat,aes(logL,logV))+
  geom_point()+
  stat_smooth(method="lm")
ggplot(ECVdat,aes(logH,logV))+
  geom_point()+
  stat_smooth(method="lm")
ggplot(ECVdat,aes(logW,logV))+
  geom_point()+
  stat_smooth(method="lm")

# Multiple regression analysis with model selection
regout <- lm(logV~logL+logH+logW,data=ECVdat,na.action="na.omit")
summary(regout)

# 95% confidence intervals for regression coefficients
confint(regout)

# Standardized regression coefficients
lm.beta(regout)

# Tolerance values (1/vif)
tol <- 1/vif(regout)
tol

# Variance inflation factors
vif(regout)

# Residual-residual plots
avPlots(regout)

# Diagnostic plots to check regression assumptions
p <- predict(regout)
r <- resid(regout)
plot(p,r)
qqnorm(r)

# New data points
newdata <- read.table(header=T,colClasses=c(rep("numeric",3)),text="
Length  Width   Height
13.15   9.05    7.00   
190.17  97.32   80.31  
")

# Need to transform values as above
newdata <- transform(newdata,logL=log(Length))
newdata <- transform(newdata,logW=log(Width))
newdata <- transform(newdata,logH=log(Height))

# Print new data
newdata

# Confidence interval for new data
predict(regout,newdata,interval="confidence")

# Prediction interval for new data
predict(regout,newdata,interval="prediction")
